require("yaml")

local function new_conf()
	local self = {}
	self.defpath = "conf/app.yml"
	
	self.load = function (self, conf)
		if conf == nil then
			conf = self.defpath
		end
		
		local fin = io.open(conf, "r")
		self.all = yaml.load(fin:read("*all"))
		return fin:close()
	end
	
	self.save = function (self, conf)
		if conf == nil then
			conf = self.defpath
		end

		local y = yaml.dump(self.all)
		local fout = io.open(conf, "w+")
		fout:write(y)
		return fout:close()
	end

	return self
end

return new_conf()